/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.IProcessRunner;
import com.aptana.core.util.InputStreamGobbler;
import com.aptana.core.util.Messages;
import com.aptana.core.util.OutputStreamThread;
import com.aptana.core.util.ProcessStatus;
import com.aptana.core.util.RegexUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.SudoCommandProcessRunnable;
import com.aptana.core.util.VersionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessRunner
implements IProcessRunner {
    private static boolean isJava7 = VersionUtil.compareVersions(System.getProperty("java.version"), "1.7") >= 0;
    private static final String MASK = StringUtil.repeat('*', 10);

    @Override
    public IStatus run(IPath workingDirectory, Map<String, String> environment, char[] input, List<String> args, IProgressMonitor monitor) {
        try {
            Process p = this.doRun(args, workingDirectory, environment, false, null, null);
            SudoCommandProcessRunnable runnable = new SudoCommandProcessRunnable(p, monitor, true, input);
            Thread t = new Thread((Runnable)runnable, "Runnable for " + args.get(0));
            t.start();
            t.join();
            return runnable.getResult();
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        catch (Exception e) {
            return new Status(4, "com.aptana.core", e.getMessage());
        }
    }

    @Override
    public Process run(String ... args) throws IOException, CoreException {
        return this.run((IPath)null, args);
    }

    @Override
    public Process run(IPath workingDirectory, String ... arguments) throws IOException, CoreException {
        return this.run(workingDirectory, (Map<String, String>)null, arguments);
    }

    @Override
    public Process run(Map<String, String> environment, String ... arguments) throws IOException, CoreException {
        return this.run(null, environment, arguments);
    }

    @Override
    public Process run(IPath workingDirectory, Map<String, String> environment, String ... arguments) throws IOException, CoreException {
        ArrayList<String> commands = new ArrayList<String>(Arrays.asList(arguments));
        return this.doRun(commands, workingDirectory, environment, false, null, null);
    }

    private Process doRun(List<String> command, IPath workingDirectory, Map<String, String> environment, boolean redirect, File outFile, File errFile) throws IOException, CoreException {
        ProcessBuilder processBuilder = this.createProcessBuilder(command);
        if (redirect) {
            try {
                Method redirectOutputMethod = processBuilder.getClass().getMethod("redirectOutput", File.class);
                redirectOutputMethod.invoke((Object)processBuilder, outFile);
                Method redirectErrorMethod = processBuilder.getClass().getMethod("redirectError", File.class);
                redirectErrorMethod.invoke((Object)processBuilder, errFile);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
            }
        }
        if (workingDirectory != null) {
            processBuilder.directory(workingDirectory.toFile());
        }
        String textToObfuscate = environment == null ? null : environment.remove("textToObfuscate");
        TreeMap<String, String> map = null;
        if (environment != null && !environment.isEmpty()) {
            map = new TreeMap<String, String>(environment);
            processBuilder.environment().putAll(environment);
        }
        if (this.isInfoLoggingEnabled("com.aptana.core/debug/shell")) {
            String path = null;
            if (processBuilder.directory() != null) {
                path = processBuilder.directory().getAbsolutePath();
            }
            this.logInfo(MessageFormat.format(Messages.ProcessUtil_RunningProcess, this.getObfuscatedCommandString(command, textToObfuscate), path, map), "com.aptana.core/debug/shell");
        }
        if (environment != null && environment.containsKey("redirectErrorStream")) {
            processBuilder.redirectErrorStream(true);
        }
        return this.startProcess(processBuilder);
    }

    protected ProcessBuilder createProcessBuilder(List<String> command) {
        return new ProcessBuilder(command);
    }

    protected boolean isInfoLoggingEnabled(String scope) {
        return IdeLog.isInfoEnabled(CorePlugin.getDefault(), scope);
    }

    protected Process startProcess(ProcessBuilder processBuilder) throws IOException {
        return processBuilder.start();
    }

    String getObfuscatedCommandString(List<String> command, String textToObfuscate) {
        String message;
        if (!StringUtil.isEmpty(textToObfuscate)) {
            String quoted = RegexUtil.quote(textToObfuscate);
            String urlPattern = "[^:]+:" + quoted + "@";
            Pattern hideMePattern = Pattern.compile(String.valueOf(urlPattern) + "|^" + quoted + "$|.*?=" + quoted);
            ArrayList<String> commandMessage = new ArrayList<String>(command.size());
            for (String arg : command) {
                if (!StringUtil.isEmpty(arg)) {
                    StringBuffer sb = new StringBuffer();
                    Matcher m = hideMePattern.matcher(arg);
                    while (m.find()) {
                        String found = m.group();
                        String replacement = MASK;
                        if (found.matches(urlPattern)) {
                            replacement = String.valueOf(found.substring(0, found.length() - (textToObfuscate.length() + 2))) + ':' + MASK + '@';
                        } else if (found.endsWith("=" + textToObfuscate)) {
                            replacement = String.valueOf(found.substring(0, found.length() - textToObfuscate.length())) + MASK;
                        }
                        m.appendReplacement(sb, replacement);
                    }
                    m.appendTail(sb);
                    arg = sb.toString();
                }
                commandMessage.add(arg);
            }
            message = StringUtil.join("\" \"", commandMessage);
        } else {
            message = StringUtil.join("\" \"", command);
        }
        return MessageFormat.format("\"{0}\"", message);
    }

    protected void logInfo(String msg, String scope) {
        IdeLog.logInfo(CorePlugin.getDefault(), msg, scope);
    }

    @Override
    public IStatus runInBackground(String ... args) {
        return this.runInBackground((IPath)null, args);
    }

    @Override
    public IStatus runInBackground(IPath workingDir, String ... args) {
        return this.runInBackground(workingDir, (Map<String, String>)null, args);
    }

    @Override
    public IStatus runInBackground(Map<String, String> environment, String ... args) {
        return this.runInBackground(null, environment, args);
    }

    @Override
    public IStatus runInBackground(IPath workingDir, Map<String, String> environment, String ... args) {
        return this.runInBackground(workingDir, environment, null, CollectionsUtil.newList(args));
    }

    @Override
    public IStatus runInBackground(IPath workingDirectory, Map<String, String> environment, String input, List<String> args) {
        return this.runInBackground(workingDirectory, environment, input, false, args);
    }

    @Override
    public IStatus runInBackground(IPath workingDirectory, Map<String, String> environment, String input, boolean redirect, List<String> arguments) {
        File outFile = null;
        File errFile = null;
        try {
            if (redirect) {
                Process p;
                outFile = File.createTempFile("studio", ".out");
                errFile = File.createTempFile("studio", ".err");
                if (isJava7) {
                    p = this.doRun(arguments, workingDirectory, environment, redirect, outFile, errFile);
                } else {
                    CollectionsUtil.addToList(arguments, ">", outFile.getAbsolutePath(), "2>", errFile.getAbsolutePath());
                    p = this.run(workingDirectory, environment, arguments.toArray(new String[arguments.size()]));
                }
                IStatus iStatus = this.processData(p, outFile, errFile);
                return iStatus;
            }
            Process p = this.run(workingDirectory, environment, arguments.toArray(new String[arguments.size()]));
            IStatus iStatus = this.processData(p, input);
            return iStatus;
        }
        catch (IOException e) {
            Status status = new Status(4, "com.aptana.core", e.getMessage(), (Throwable)e);
            return status;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            if (outFile != null) {
                outFile.delete();
            }
            if (errFile != null) {
                errFile.delete();
            }
        }
    }

    private IStatus processData(Process process, File outputFile, File errorFile) {
        FileInputStream inputStream = null;
        FileInputStream errorStream = null;
        try {
            inputStream = new FileInputStream(outputFile);
            errorStream = new FileInputStream(errorFile);
            IStatus iStatus = this.processData(inputStream, errorStream, null, null, process, true);
            return iStatus;
        }
        catch (FileNotFoundException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (errorStream != null) {
                    errorStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private IStatus processData(Process process, String input) {
        return this.processData(process.getInputStream(), process.getErrorStream(), process.getOutputStream(), input, process, false);
    }

    private IStatus processData(InputStream inputStream, InputStream errorStream, OutputStream outputStream, String input, Process process, boolean earlyWait) {
        String lineSeparator = ResourceUtil.getLineSeparatorValue(null);
        Thread readerGobbler = null;
        Thread errorGobbler = null;
        try {
            int exitValue = 0;
            if (earlyWait) {
                exitValue = process.waitFor();
            }
            OutputStreamThread writerThread = null;
            if (!StringUtil.isEmpty(input)) {
                writerThread = new OutputStreamThread(outputStream, input, "UTF-8");
            }
            readerGobbler = new InputStreamGobbler(inputStream, lineSeparator, "UTF-8");
            errorGobbler = new InputStreamGobbler(errorStream, lineSeparator, null);
            if (writerThread != null) {
                writerThread.start();
            }
            readerGobbler.start();
            errorGobbler.start();
            if (!earlyWait) {
                exitValue = process.waitFor();
            }
            if (writerThread != null) {
                writerThread.interrupt();
                writerThread.join();
            }
            readerGobbler.interrupt();
            errorGobbler.interrupt();
            readerGobbler.join();
            errorGobbler.join();
            String stdout = ((InputStreamGobbler)readerGobbler).getResult();
            String stderr = ((InputStreamGobbler)errorGobbler).getResult();
            this.logProcessOutput(stdout, stderr);
            return new ProcessStatus(exitValue, stdout, stderr);
        }
        catch (InterruptedException e) {
            String stdout = "";
            String stderr = "";
            try {
                if (readerGobbler != null) {
                    readerGobbler.interrupt();
                }
                if (errorGobbler != null) {
                    errorGobbler.interrupt();
                }
                if (readerGobbler != null) {
                    readerGobbler.join();
                    stdout = ((InputStreamGobbler)readerGobbler).getResult();
                }
                if (errorGobbler != null) {
                    errorGobbler.join();
                    stderr = ((InputStreamGobbler)errorGobbler).getResult();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return new ProcessStatus(stdout, stderr, e);
        }
    }

    private void logProcessOutput(String stdout, String stderr) {
        if (this.isInfoLoggingEnabled("com.aptana.core/debug/shell/output")) {
            StringBuilder sb = new StringBuilder();
            if (!StringUtil.isEmpty(stderr)) {
                sb.append("Process Error Output:");
                sb.append(FileUtil.NEW_LINE);
                sb.append(stderr);
                sb.append(FileUtil.NEW_LINE);
            }
            if (!StringUtil.isEmpty(stdout)) {
                sb.append("Process Output:");
                sb.append(FileUtil.NEW_LINE);
                sb.append(stdout);
            }
            this.logInfo(sb.toString(), "com.aptana.core/debug/shell/output");
        }
    }

    @Override
    public IStatus processResult(Process p) {
        return this.processData(p, null);
    }

    @Override
    public String outputForProcess(Process process) {
        IStatus result = this.processData(process, null);
        if (result == null) {
            return null;
        }
        return result.getMessage();
    }
}

